package com.ejie.ab04b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ComunicacionAperturaDao generated by UDA, 26-dic-2016 13:08:26.
 * 
 * @author UDA
 */

public interface ComunicacionAperturaDao {

	/**
	 * Inserts a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura add(ComunicacionApertura comunicApertura);

	/**
	 * Inserts a single row in the Ab04b56s00 table.
	 * 
	 * apertura ComunicacionApertura Ab04b56s00
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura addFromSolicitudNumReg(ComunicacionApertura apertura);

	/**
	 * Inserts a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura addPresencial(ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura update(ComunicacionApertura comunicApertura);

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateFilled(ComunicacionApertura apertura);

	/**
	 * Updates a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabProcAlmac(
			ComunicacionApertura comunicApertura);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosObra(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosCentro(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosCentroAsignado(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosVisitaOsalan(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabDatosEmpresa(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabEstadoDoc(
			ComunicacionApertura apertura);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabNotificacion(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosTabNotificacionContacto(
			ComunicacionApertura ab04b56s00);

	/**
	 * Finds a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura find(ComunicacionApertura comunicApertura);

	/**
	 * Finds a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura find3(ComunicacionApertura comunicApertura);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * folderId String Ab04b56s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura findByFolderId(String folderId);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * folderId String Ab04b56s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the comunicacion apertura
	 */
	@Transactional(readOnly = true)
	public ComunicacionApertura findByFolderId2(String folderId);

	/**
	 * Removes a single row in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 */
	void remove(ComunicacionApertura comunicApertura);

	/**
	 * Finds a List of rows in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * List
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	List<ComunicacionApertura> findAll(ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the ComunicacionApertura table using like.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<ComunicacionApertura> findAllLike(ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds rows in the ComunicacionApertura table for Reenvio de
	 * Comunicaciones.
	 * 
	 * comunicApertura ComunicacionApertura jqGridRequestDto JQGridRequestDto
	 * List
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	List<ComunicacionApertura> findReenvioComunicaciones(
			ComunicacionApertura comunicApertura,
			JQGridRequestDto jqGridRequestDto);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the ComunicacionApertura table.
	 * 
	 * filterComunicacionApertura ComunicacionApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	void removeMultiple(ComunicacionApertura filterComunicacionApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the ComunicacionApertura table using like.
	 * 
	 * comunicApertura ComunicacionApertura startsWith Boolean Long
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	Long findAllLikeCount(ComunicacionApertura comunicApertura,
			Boolean startsWith);

	/**
	 * Counts rows in the ComunicacionApertura table.
	 * 
	 * comunicApertura ComunicacionApertura Long
	 * 
	 * @param comunicApertura
	 *            the comunic apertura
	 * @return the long
	 */
	Long findAllCount(ComunicacionApertura comunicApertura);

	/**
	 * Reorder selection.
	 * 
	 * filterComunicacionApertura ComunicacionApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <ComunicacionApertura>>
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<TableRowDto<ComunicacionApertura>> reorderSelection(
			ComunicacionApertura filterComunicacionApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * filterComunicacionApertura ComunicacionApertura
	 * searchComunicacionApertura ComunicacionApertura jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <ComunicacionApertura>>
	 * 
	 * @param filterComunicacionApertura
	 *            the filter comunicacion apertura
	 * @param searchComunicacionApertura
	 *            the search comunicacion apertura
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<TableRowDto<ComunicacionApertura>> search(
			ComunicacionApertura filterComunicacionApertura,
			ComunicacionApertura searchComunicacionApertura,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds rows in the Ab04b56s00 table using like.
	 * 
	 * ab04b56s00 Ab04b56s00 List<Ab04b56s00>
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the list
	 */
	List<ComunicacionApertura> findEmpresaObra(ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura updateCodObra(ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura modificarDatosRegistro(
			ComunicacionApertura ab04b56s00);

	/**
	 * Finds a single row in the Ab04b56s00 table.
	 * 
	 * comunicacionApertura ComunicacionApertura Ab04b56s00
	 * 
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findDatosRegistro(
			ComunicacionApertura comunicacionApertura);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * apertura ComunicacionApertura ComunicacionApertura
	 * 
	 * @param apertura
	 *            the apertura
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura updateCierre(ComunicacionApertura apertura);

	/**
	 * Update cierre temporal.
	 * 
	 * apertura the apertura
	 * 
	 * @param apertura
	 *            the apertura
	 */
	void updateCierreTemporal(ComunicacionApertura apertura);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 updateFechaRecInspecc updateFechaRecInspecc
	 * Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param updateFechaRecInspecc
	 *            the update fecha rec inspecc
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateFecInspeccion(
			ComunicacionApertura ab04b56s00, boolean updateFechaRecInspecc);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateFecFinPlazo(
			ComunicacionApertura ab04b56s00);

	/**
	 * Updates a single row in the Ab04b56s00 table.
	 * 
	 * ab04b56s00 Ab04b56s00 Ab04b56s00
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura updateUsuariosTramitacion(
			ComunicacionApertura ab04b56s00);

	/**
	 * Find last S sof num doc.
	 * 
	 * filtro the filtro the comunicacion apertura
	 * 
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findLastSSofNumDoc(ComunicacionApertura filtro);

	/**
	 * Find last RE aof num doc.
	 * 
	 * filtro the filtro the comunicacion apertura
	 * 
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion apertura
	 */
	ComunicacionApertura findLastREAofNumDoc(ComunicacionApertura filtro);

	/**
	 * Counts rows in the PORTAL table.
	 * 
	 * comunicacionApertura ComunicacionApertura Long
	 * 
	 * @param comunicacionApertura
	 *            the ab 04 b 56 s 00
	 * @return the long
	 */
	Long findCPenLocalidadCount(ComunicacionApertura comunicacionApertura);

	void updateBatchSub(ComunicacionApertura apertura);

	void updateFecSub(ComunicacionApertura apertura);
}
